/*
 * Decompiled with CFR 0.152.
 */
package setGame;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JPanel;
import setGame.GameKI;
import setGame.PlayingCard;

class PlayingTable
extends JPanel {
    static final Color[] CARDCOLORS = new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 255), new Color(0, 0, 255, 255), new Color(255, 0, 0, 96), new Color(0, 255, 0, 96), new Color(0, 0, 255, 96), new Color(255, 0, 0, 0), new Color(0, 255, 0, 0), new Color(0, 0, 255, 0)};
    static final Point[][] SYMBOLCENTERS = new Point[][]{{new Point(35, 55)}, {new Point(35, 36), new Point(35, 76)}, {new Point(35, 15), new Point(35, 55), new Point(35, 95)}};
    private GameKI gameKI;

    private final void ShowCard(Graphics g, PlayingCard card, int x, int y) {
        int[] cornersX = new int[3];
        int[] cornersY = new int[3];
        g.setColor(Color.white);
        ((Graphics2D)g).setStroke(new BasicStroke(4));
        g.fillRoundRect(x * 80, y * 120, 70, 110, 4, 4);
        switch (card.symbol) {
            case 0: {
                Point[] coordsSet = SYMBOLCENTERS[card.num - 1];
                int i = 0;
                while (i < card.num) {
                    Point center = coordsSet[i];
                    g.setColor(CARDCOLORS[card.color + 3 * card.filling]);
                    g.fillRect(x * 80 + center.x - 20, y * 120 + center.y - 10, 40, 20);
                    g.setColor(CARDCOLORS[card.color]);
                    g.drawRect(x * 80 + center.x - 20, y * 120 + center.y - 10, 40, 20);
                    ++i;
                }
                break;
            }
            case 1: {
                Point[] coordsSet = SYMBOLCENTERS[card.num - 1];
                int i = 0;
                while (i < card.num) {
                    Point center = coordsSet[i];
                    g.setColor(CARDCOLORS[card.color + 3 * card.filling]);
                    g.fillArc(x * 80 + center.x - 20, y * 120 + center.y - 10, 40, 20, 0, 360);
                    g.setColor(CARDCOLORS[card.color]);
                    g.drawArc(x * 80 + center.x - 20, y * 120 + center.y - 10, 40, 20, 0, 360);
                    ++i;
                }
                break;
            }
            case 2: {
                Point[] coordsSet = SYMBOLCENTERS[card.num - 1];
                int i = 0;
                while (i < card.num) {
                    Point center = coordsSet[i];
                    cornersX[0] = x * 80 + center.x - 10;
                    cornersY[0] = y * 120 + center.y + 10;
                    cornersX[1] = x * 80 + center.x;
                    cornersY[1] = y * 120 + center.y - 10;
                    cornersX[2] = x * 80 + center.x + 10;
                    cornersY[2] = y * 120 + center.y + 10;
                    g.setColor(CARDCOLORS[card.color + 3 * card.filling]);
                    g.fillPolygon(cornersX, cornersY, 3);
                    g.setColor(CARDCOLORS[card.color]);
                    g.drawPolygon(cornersX, cornersY, 3);
                    ++i;
                }
                break;
            }
        }
        if (card.selected) {
            g.setColor(new Color(0, 0, 0, 20));
            ((Graphics2D)g).setStroke(new BasicStroke(4));
            g.fillRoundRect(x * 80, y * 120, 70, 110, 4, 4);
            g.setColor(Color.black);
            g.drawRoundRect(x * 80, y * 120, 70, 110, 4, 4);
        }
    }

    private final void ShowCards(Graphics g, ArrayList cardsOnTable) {
        int x = 0;
        while (x < cardsOnTable.size() / 3) {
            int y = 0;
            while (y < 3) {
                this.ShowCard(g, (PlayingCard)cardsOnTable.get(x * 3 + y), x, y);
                ++y;
            }
            ++x;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.ShowCards(g, this.gameKI.cardsOnTable);
    }

    public PlayingTable(GameKI ki) {
        this.gameKI = ki;
        this.setPreferredSize(new Dimension(560, 360));
    }
}

