/*
 * Decompiled with CFR 0.152.
 */
package setGame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import setGame.GameKI;
import setGame.PlayingTable;

class GameUI
extends JPanel
implements MouseListener,
ActionListener {
    private GameKI ki = new GameKI();
    private PlayingTable playingTable;
    JTextField statusBar;

    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            int cardIndex = -1;
            Point clickPoint = arg0.getPoint();
            int cardX = clickPoint.x / 80;
            int cardY = clickPoint.y / 120;
            if (cardX < this.ki.cardsOnTable.size() / 3 && cardY < 3) {
                cardIndex = cardX * 3 + cardY;
                this.ki.SelectCard(cardIndex);
                this.playingTable.repaint();
                this.statusBar.setText("Cards left: " + this.ki.numCardsLeft);
                this.statusBar.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("addCards") && this.ki != null) {
            this.ki.AddCards();
            this.statusBar.setText("Cards left: " + this.ki.numCardsLeft);
            this.statusBar.repaint();
            this.playingTable.repaint();
        }
        if (arg0.getActionCommand().equals("newGame")) {
            this.ki.Initialize();
            this.ki.CreateCardSet();
            this.ki.InitialConfiguration();
            this.statusBar.setText("Cards left: " + this.ki.numCardsLeft);
            this.statusBar.repaint();
            this.playingTable.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setTitle("The Set game");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new GameUI(true));
        f.pack();
        f.show();
    }

    public GameUI(boolean standalone) {
        this.ki.Initialize();
        this.ki.CreateCardSet();
        this.ki.InitialConfiguration();
        this.playingTable = new PlayingTable(this.ki);
        this.playingTable.addMouseListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton addCardButton = new JButton("Add cards");
        addCardButton.setActionCommand("addCards");
        addCardButton.addActionListener(this);
        JButton newGameButton = new JButton("New game");
        newGameButton.setActionCommand("newGame");
        newGameButton.addActionListener(this);
        buttonPanel.add(newGameButton);
        buttonPanel.add(addCardButton);
        this.statusBar = new JTextField("Cards left : 69");
        this.statusBar.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonPanel, "North");
        this.add((Component)this.playingTable, "Center");
        this.add((Component)this.statusBar, "South");
    }
}

