/*
 * Decompiled with CFR 0.152.
 */
package setGame;

import java.util.ArrayList;
import setGame.PlayingCard;
import setGame.PlayingCardTriple;

class GameKI {
    private ArrayList cardsLeft;
    public int numCardsLeft;
    private int numSelected;
    public ArrayList cardsOnTable;

    void Initialize() {
        this.cardsLeft = new ArrayList();
        this.cardsOnTable = new ArrayList();
        this.numSelected = 0;
        this.numCardsLeft = 0;
    }

    public void CreateCardSet() {
        boolean cardIndex = false;
        int symbol = 0;
        while (symbol < 3) {
            int color = 0;
            while (color < 3) {
                int count = 0;
                while (count < 3) {
                    int filling = 0;
                    while (filling < 3) {
                        this.cardsLeft.add(new PlayingCard(symbol, count + 1, color, filling));
                        ++this.numCardsLeft;
                        ++filling;
                    }
                    ++count;
                }
                ++color;
            }
            ++symbol;
        }
    }

    public PlayingCard GetCard() {
        int cardIndex = (int)(Math.random() * (double)this.numCardsLeft);
        PlayingCard takenCard = (PlayingCard)this.cardsLeft.get(cardIndex);
        this.cardsLeft.remove(cardIndex);
        --this.numCardsLeft;
        return takenCard;
    }

    public void InitialConfiguration() {
        int i = 0;
        while (i < 12) {
            this.cardsOnTable.add(this.GetCard());
            ++i;
        }
    }

    public void AddCards() {
        if (this.numCardsLeft >= 3) {
            int i = 0;
            while (i < 3) {
                this.cardsOnTable.add(this.GetCard());
                ++i;
            }
        }
    }

    public boolean ReplaceCards(PlayingCardTriple foundTriple) {
        if (this.cardsLeft.size() < 3) {
            this.RemoveCards(foundTriple);
            return true;
        }
        int i = 0;
        while (i < this.cardsOnTable.size()) {
            PlayingCard currentCard = (PlayingCard)this.cardsOnTable.get(i);
            if (foundTriple.Contains(currentCard)) {
                this.cardsOnTable.set(i, this.GetCard());
                continue;
            }
            ++i;
        }
        return true;
    }

    public void RemoveCards(PlayingCardTriple foundTriple) {
        int i = 0;
        while (i < this.cardsOnTable.size()) {
            PlayingCard currentCard = (PlayingCard)this.cardsOnTable.get(i);
            if (foundTriple.Contains(currentCard)) {
                this.cardsOnTable.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean FindSet(PlayingCardTriple inspectedTriple) {
        int i = 0;
        while (i < this.cardsOnTable.size()) {
            int j = i + 1;
            while (j < this.cardsOnTable.size()) {
                int k = j + 1;
                while (k < this.cardsOnTable.size()) {
                    inspectedTriple.pc[0] = (PlayingCard)this.cardsOnTable.get(i);
                    inspectedTriple.pc[1] = (PlayingCard)this.cardsOnTable.get(j);
                    inspectedTriple.pc[2] = (PlayingCard)this.cardsOnTable.get(k);
                    if (inspectedTriple.IsSet()) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private final PlayingCardTriple GetSelectedCards() {
        PlayingCardTriple resultTriple = new PlayingCardTriple();
        int sc = 0;
        int i = 0;
        while (i < this.cardsOnTable.size()) {
            PlayingCard currentCard = (PlayingCard)this.cardsOnTable.get(i);
            if (currentCard.selected) {
                resultTriple.pc[sc++] = currentCard;
            }
            ++i;
        }
        return resultTriple;
    }

    public synchronized boolean SelectCard(int i) {
        PlayingCardTriple selectedTriple;
        PlayingCard selectedCard = (PlayingCard)this.cardsOnTable.get(i);
        if (!selectedCard.selected && this.numSelected >= 3) {
            return true;
        }
        selectedCard.selected ^= true;
        this.numSelected = selectedCard.selected ? ++this.numSelected : --this.numSelected;
        System.out.println(this.numSelected);
        if (this.numSelected == 3 && (selectedTriple = this.GetSelectedCards()).IsSet()) {
            this.numSelected = 0;
            if (this.cardsOnTable.size() <= 12) {
                return this.ReplaceCards(selectedTriple);
            }
            this.RemoveCards(selectedTriple);
            return false;
        }
        return true;
    }

    GameKI() {
    }
}

