/*
 * Decompiled with CFR 0.152.
 */
package ujap.fun;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MasterMind
extends JPanel {
    static final ResourceBundle resources = ResourceBundle.getBundle(MasterMind.class.getName());
    private static final int gehtnicht = -100;
    private static final int MAX_ZAHL = 7;
    private static final int MAX_VERS = 19;
    private static final Color[] c = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.yellow, Color.cyan, Color.black, Color.red.darker().darker(), Color.blue.darker().darker(), Color.green.darker().darker(), Color.yellow.darker().darker()};
    static final Font font = new Font("Helvetica", 1, 16);
    int n;
    private int vers;
    private double zeit;
    int versuch_nummer;
    private boolean compi;
    private Computer computer;
    private int[] zahl;
    JTextField[][] rate;
    JTextField[][] ergebnis;
    private JTextField[] verborgene;
    JTextField[] nachricht;
    boolean showNachricht = false;
    private Component nachrichtenLabel;
    private JButton helpButton;
    private NeuDialog neudialog;
    boolean standAlone = true;
    static final WindowAdapter closer = new WindowAdapter(){

        public void windowClosing(WindowEvent evt) {
            System.exit(0);
        }
    };

    public MasterMind(boolean standAlone) {
        this.standAlone = standAlone;
        this.neudialog = new NeuDialog();
        this.initGui();
        this.reset();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setTitle("Master Mind");
        f.addWindowListener(closer);
        f.getContentPane().add(new MasterMind(true));
        f.pack();
        f.show();
    }

    private void reset() {
        this.neudialog.show();
        this.n = this.neudialog.slider.getValue();
        switch (this.n) {
            case 3: {
                this.vers = 9;
                break;
            }
            case 4: {
                this.vers = 11;
                break;
            }
            case 5: {
                this.vers = 13;
                break;
            }
            case 6: {
                this.vers = 15;
                break;
            }
            case 7: {
                this.vers = 19;
            }
        }
        this.compi = !this.neudialog.mensch.isSelected();
        this.showNachricht = this.neudialog.nachricht1.isSelected();
        this.resetGui();
        this.zahl = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.zahl[i] = (int)(Math.random() * 10.0);
        }
        this.versuch_nummer = 0;
        this.rate[0][0].requestFocus();
        this.zeit = System.currentTimeMillis();
        Container c1 = null;
        c1 = SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (c1 != null) {
            ((Frame)c1).pack();
        }
        this.computer = new Computer(this.compi);
        this.helpButton.setAction(this.computer);
        if (this.compi) {
            this.verborg();
            this.helpButton.setText(resources.getString("button.computer"));
        } else {
            this.helpButton.setText(resources.getString("button.hint"));
        }
    }

    private void initGui() {
        int zeile;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.rate = new JTextField[19][7];
        this.ergebnis = new JTextField[19][2];
        this.verborgene = new JTextField[7];
        this.nachricht = new JTextField[19];
        JPanel p = new JPanel(new FlowLayout());
        p.add(new JLabel(resources.getString("label.verborgenezahlen")));
        JPanel felder = new JPanel(new GridBagLayout());
        GridBagConstraints pc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0);
        for (int i = 0; i < 7; ++i) {
            this.verborgene[i] = new JTextField(2);
            this.enableText(this.verborgene[i], false);
            this.verborgene[i].setFont(font);
            this.verborgene[i].setHorizontalAlignment(0);
            this.verborgene[i].setFocusTraversalKeysEnabled(false);
            this.verborgene[i].setFocusable(false);
            pc.gridx = i;
            felder.add((Component)this.verborgene[i], pc);
        }
        p.add(felder);
        this.add((Component)p, gc);
        gc.gridwidth = 1;
        gc.gridy = 1;
        gc.insets = new Insets(10, 10, 0, 0);
        JLabel l = new JLabel(resources.getString("label.deineversuche"));
        gbl.setConstraints(l, gc);
        this.add((Component)l, gc);
        gc.gridy = 2;
        gc.weighty = 5.0;
        gc.anchor = 11;
        gc.insets = new Insets(10, 10, 10, 0);
        felder = new JPanel(new GridBagLayout());
        pc.insets = new Insets(0, 2, 5, 3);
        for (zeile = 0; zeile < 19; ++zeile) {
            for (int spalte = 0; spalte < 7; ++spalte) {
                this.rate[zeile][spalte] = new JTextField(2);
                Changer c1 = new Changer(zeile, spalte);
                this.rate[zeile][spalte].addKeyListener(c1);
                this.rate[zeile][spalte].setFont(font);
                this.rate[zeile][spalte].setFocusTraversalKeysEnabled(false);
                this.rate[zeile][spalte].setFocusable(true);
                this.rate[zeile][spalte].setHorizontalAlignment(0);
                pc.gridy = zeile;
                pc.gridx = spalte;
                felder.add((Component)this.rate[zeile][spalte], pc);
            }
        }
        gbl.setConstraints(felder, gc);
        this.add((Component)felder, gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.anchor = 10;
        gc.insets = new Insets(10, 10, 0, 0);
        l = new JLabel(resources.getString("label.richtige"));
        gbl.setConstraints(l, gc);
        this.add((Component)l, gc);
        gc.gridy = 2;
        gc.weighty = 5.0;
        gc.anchor = 11;
        gc.insets = new Insets(10, 10, 10, 0);
        felder = new JPanel(new GridBagLayout());
        pc.gridx = 0;
        for (zeile = 0; zeile < 19; ++zeile) {
            this.ergebnis[zeile][0] = new JTextField(2);
            this.enableText(this.ergebnis[zeile][0], false);
            this.ergebnis[zeile][0].setFont(font);
            this.ergebnis[zeile][0].setHorizontalAlignment(0);
            this.ergebnis[zeile][0].setFocusTraversalKeysEnabled(false);
            this.ergebnis[zeile][0].setFocusable(false);
            pc.gridy = zeile;
            felder.add((Component)this.ergebnis[zeile][0], pc);
        }
        gbl.setConstraints(felder, gc);
        this.add((Component)felder, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.anchor = 10;
        gc.insets = new Insets(10, 10, 0, 10);
        l = new JLabel(resources.getString("label.richtigerort"));
        gbl.setConstraints(l, gc);
        this.add((Component)l, gc);
        gc.gridy = 2;
        gc.weighty = 5.0;
        gc.anchor = 11;
        gc.insets = new Insets(10, 10, 10, 10);
        felder = new JPanel(new GridBagLayout());
        pc.gridx = 0;
        for (zeile = 0; zeile < 19; ++zeile) {
            this.ergebnis[zeile][1] = new JTextField(2);
            this.enableText(this.ergebnis[zeile][1], false);
            this.ergebnis[zeile][1].setFont(font);
            this.ergebnis[zeile][1].setFocusTraversalKeysEnabled(false);
            this.ergebnis[zeile][1].setFocusable(false);
            this.ergebnis[zeile][1].setHorizontalAlignment(0);
            pc.gridy = zeile;
            felder.add((Component)this.ergebnis[zeile][1], pc);
        }
        gbl.setConstraints(felder, gc);
        this.add((Component)felder, gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.weighty = 1.0;
        gc.anchor = 10;
        gc.insets = new Insets(10, 10, 0, 10);
        l = new JLabel(resources.getString("label.versuchanzahl"));
        gbl.setConstraints(l, gc);
        this.add((Component)l, gc);
        this.nachrichtenLabel = l;
        gc.gridx = 3;
        gc.gridy = 2;
        gc.weighty = 5.0;
        gc.anchor = 11;
        gc.insets = new Insets(10, 10, 10, 10);
        felder = new JPanel(new GridBagLayout());
        pc.gridx = 0;
        for (zeile = 0; zeile < 19; ++zeile) {
            this.nachricht[zeile] = new JTextField();
            this.enableText(this.nachricht[zeile], false);
            this.nachricht[zeile].setFont(font);
            this.nachricht[zeile].setFocusTraversalKeysEnabled(false);
            this.nachricht[zeile].setFocusable(false);
            this.nachricht[zeile].setHorizontalAlignment(0);
            pc.gridy = zeile;
            felder.add((Component)this.nachricht[zeile], pc);
        }
        gbl.setConstraints(felder, gc);
        this.add((Component)felder, gc);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 4;
        gc.anchor = 10;
        gc.fill = 0;
        this.helpButton = new JButton();
        this.add((Component)this.helpButton, gc);
    }

    private void resetGui() {
        for (int spalte = 0; spalte < 7; ++spalte) {
            this.verborgene[spalte].setVisible(spalte < this.n);
            this.verborgene[spalte].setText("");
        }
        for (int zeile = 0; zeile < 19; ++zeile) {
            int spalte;
            for (spalte = 0; spalte < 7; ++spalte) {
                this.rate[zeile][spalte].setVisible(zeile < this.vers && spalte < this.n);
                this.rate[zeile][spalte].setText("");
                this.enableText(this.rate[zeile][spalte], zeile == 0);
            }
            for (spalte = 0; spalte < 2; ++spalte) {
                this.ergebnis[zeile][spalte].setVisible(zeile < this.vers);
                this.ergebnis[zeile][spalte].setText("");
            }
            if (this.showNachricht) {
                this.nachricht[zeile].setVisible(zeile < this.vers);
                this.nachricht[zeile].setText("");
                this.nachricht[zeile].setColumns(this.n);
                continue;
            }
            this.nachricht[zeile].setVisible(false);
        }
        this.nachrichtenLabel.setVisible(this.showNachricht);
    }

    private void enableText(JTextField t, boolean enabled) {
        t.setEditable(enabled);
        t.setBackground(Color.white);
    }

    private int[] richtige(int[] z) {
        int i;
        int[] za = new int[this.n];
        int rp = 0;
        int r = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            za[i2] = this.zahl[i2];
            if (za[i2] != z[i2]) continue;
            ++rp;
        }
        int[] zz = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            zz[i] = z[i];
        }
        block2: for (i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (za[j] == -100 || zz[i] != za[j]) continue;
                ++r;
                za[j] = -100;
                zz[i] = -100;
                continue block2;
            }
        }
        this.ergebnis[this.versuch_nummer][0].setText("" + r);
        this.ergebnis[this.versuch_nummer][1].setText("" + rp);
        ++this.versuch_nummer;
        if (this.versuch_nummer < this.vers) {
            this.rate[this.versuch_nummer][0].requestFocus();
        }
        return new int[]{r, rp};
    }

    void checkRow(int zeile, int spalte, int neueSpalte) {
        if (spalte != this.n - 1 || !this.zeileVoll(zeile)) {
            this.rate[zeile][neueSpalte % this.n].requestFocus();
            return;
        }
        int[] z = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.enableText(this.rate[zeile][i], false);
            if (zeile < this.vers - 1) {
                this.enableText(this.rate[zeile + 1][i], true);
            }
            z[i] = Integer.parseInt(this.rate[zeile][i].getText());
        }
        int[] r = this.richtige(z);
        if (this.showNachricht) {
            this.computer.showCount();
        }
        if (r[0] == this.n && r[1] == this.n || this.versuch_nummer == this.vers) {
            this.gewonnen(r[0] == this.n && r[1] == this.n);
            return;
        }
        if (this.compi && this.computer != null) {
            this.computer.stateChanged(null);
        }
    }

    private void verborg() {
        for (int i = 0; i < this.n; ++i) {
            this.verborgene[i].setForeground(c[this.zahl[i]]);
            this.verborgene[i].setText("" + this.zahl[i]);
        }
    }

    private void gewonnen(boolean gewonnen) {
        this.verborg();
        String sek = " " + resources.getString("ergebnis.sekunden");
        this.zeit = ((double)System.currentTimeMillis() - this.zeit) / 1000.0;
        if (this.zeit > 600.0) {
            this.zeit /= 60.0;
            sek = " " + resources.getString("ergebnis.minuten");
        }
        String vs = " " + this.versuch_nummer + " (" + this.versuch_nummer * 100 / this.vers + "%)";
        sek = resources.getString("ergebnis.zeit") + " " + (int)this.zeit + sek;
        vs = resources.getString("ergebnis.versuche") + vs;
        if (gewonnen) {
            this.neudialog.setErgebnis(true, sek, vs);
        } else {
            this.neudialog.setErgebnis(false, sek, vs);
        }
        this.reset();
    }

    private boolean zeileVoll(int zeile) {
        for (int i = 0; i < this.n; ++i) {
            if (this.rate[zeile][i].getText().trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    void update(int zahl1, int zeile, int spalte) {
        this.rate[zeile][spalte].setForeground(c[zahl1]);
        this.rate[zeile][spalte].setText("" + zahl1);
        this.checkRow(zeile, spalte, spalte + 1);
    }

    private class Computer
    extends AbstractAction
    implements ChangeListener {
        private int alle = 0;
        private boolean[] compiVersuche = null;
        private int working = 0;
        private int count;
        private int vmax;
        private int zuletzt_ausgewertet = -1;

        public Computer(boolean active) {
            this.count = this.vmax = (int)Math.pow(10.0, MasterMind.this.n);
            if (active) {
                this.init();
            }
        }

        private void init() {
            this.compiVersuche = new boolean[this.vmax];
            for (int i = 0; i < this.vmax; ++i) {
                this.compiVersuche[i] = true;
            }
        }

        public synchronized void actionPerformed(ActionEvent evt) {
            this.checkAuswertung();
            if ((MasterMind.this.versuch_nummer < 3 && MasterMind.this.n != 5 || MasterMind.this.versuch_nummer < 2) && this.alle != MasterMind.this.n) {
                this.anfang();
            } else {
                while (this.working < this.vmax && !this.compiVersuche[this.working]) {
                    ++this.working;
                }
                if (this.working >= this.vmax) {
                    throw new InternalError("No solution found.");
                }
                int ii = this.working;
                for (int j = 0; j < MasterMind.this.n; ++j) {
                    MasterMind.this.update(this.stelle(ii, j), MasterMind.this.versuch_nummer, j);
                }
            }
        }

        private void checkAuswertung() {
            if (this.compiVersuche == null) {
                this.init();
            }
            for (int i = this.zuletzt_ausgewertet + 1; i < MasterMind.this.versuch_nummer; ++i) {
                this.auswertung(i);
            }
            this.zuletzt_ausgewertet = MasterMind.this.versuch_nummer - 1;
        }

        void showCount() {
            this.checkAuswertung();
            if (MasterMind.this.showNachricht) {
                MasterMind.this.nachricht[MasterMind.this.versuch_nummer - 1].setText("" + this.count);
            }
        }

        private void auswertung(int v) {
            int[] z = new int[MasterMind.this.n];
            for (int j = 0; j < MasterMind.this.n; ++j) {
                z[j] = Integer.parseInt(MasterMind.this.rate[v][j].getText());
            }
            int r = Integer.parseInt(MasterMind.this.ergebnis[v][0].getText());
            int rp = Integer.parseInt(MasterMind.this.ergebnis[v][1].getText());
            this.killversuch(this.vmax, z, r, rp);
            this.alle += r;
        }

        private void anfang() {
            int i;
            int[] z = new int[MasterMind.this.n];
            switch (MasterMind.this.n) {
                case 3: {
                    for (i = 0; i < MasterMind.this.n; ++i) {
                        z[i] = i + MasterMind.this.versuch_nummer * MasterMind.this.n;
                    }
                    break;
                }
                case 4: {
                    for (i = 0; i < MasterMind.this.n; ++i) {
                        z[i] = i + MasterMind.this.versuch_nummer * MasterMind.this.n;
                        if (z[i] == 10) {
                            z[i] = 8;
                        }
                        if (z[i] != 11) continue;
                        z[i] = 9;
                    }
                    break;
                }
                case 5: {
                    for (i = 0; i < MasterMind.this.n; ++i) {
                        z[i] = i + MasterMind.this.versuch_nummer * MasterMind.this.n;
                    }
                    break;
                }
                case 6: {
                    for (i = 0; i < 3; ++i) {
                        z[i] = i + MasterMind.this.versuch_nummer * 3;
                        z[i + 3] = z[i];
                    }
                    break;
                }
                case 7: {
                    for (i = 0; i < 3; ++i) {
                        z[i] = i + MasterMind.this.versuch_nummer * 3;
                        z[i + 3] = z[i];
                    }
                    z[6] = z[0];
                    if (MasterMind.this.versuch_nummer != 2) break;
                    z[6] = 9;
                }
            }
            for (i = 0; i < MasterMind.this.n; ++i) {
                MasterMind.this.update(z[i], MasterMind.this.versuch_nummer, i);
            }
        }

        private void killversuch(int vmax1, int[] a, int r, int rp) {
            boolean durchgehend = true;
            block0: for (int i = this.working; i < vmax1; ++i) {
                if (!this.compiVersuche[i]) continue;
                int ii = i;
                if (ii != -100) {
                    int j;
                    int richt = 0;
                    int richtplatz = 0;
                    for (j = 0; j < MasterMind.this.n; ++j) {
                        if (this.stelle(ii, j) != a[j]) continue;
                        ++richtplatz;
                    }
                    if (richtplatz != rp) {
                        this.compiVersuche[i] = false;
                        --this.count;
                        if (!durchgehend) continue;
                        ++this.working;
                        continue;
                    }
                    int[] zz = new int[MasterMind.this.n];
                    int[] za = new int[MasterMind.this.n];
                    for (j = 0; j < MasterMind.this.n; ++j) {
                        za[j] = this.stelle(ii, j);
                        zz[j] = a[j];
                    }
                    block3: for (j = 0; j < MasterMind.this.n; ++j) {
                        for (int k = 0; k < MasterMind.this.n; ++k) {
                            if (za[k] == -100 || zz[j] != za[k]) continue;
                            if (++richt > r) {
                                this.compiVersuche[i] = false;
                                --this.count;
                                if (!durchgehend) continue block0;
                                ++this.working;
                                continue block0;
                            }
                            za[k] = -100;
                            zz[j] = -100;
                            continue block3;
                        }
                    }
                    if (richt != r || richtplatz != rp) {
                        this.compiVersuche[i] = false;
                        --this.count;
                        if (!durchgehend) continue;
                        ++this.working;
                        continue;
                    }
                }
                durchgehend = false;
            }
        }

        private int stelle(int x, int n1) {
            switch (n1) {
                case 0: {
                    return x % 10;
                }
                case 1: {
                    return x / 10 % 10;
                }
                case 2: {
                    return x / 100 % 10;
                }
                case 3: {
                    return x / 1000 % 10;
                }
                case 4: {
                    return x / 10000 % 10;
                }
                case 5: {
                    return x / 100000 % 10;
                }
                case 6: {
                    return x / 1000000 % 10;
                }
            }
            throw new InternalError("illegal stelle");
        }

        public void stateChanged(ChangeEvent e) {
            this.actionPerformed(null);
        }
    }

    private class Changer
    extends KeyAdapter
    implements FocusListener {
        private int zeile;
        private int spalte;

        public Changer(int zeile, int spalte) {
            this.zeile = zeile;
            this.spalte = spalte;
        }

        public void keyTyped(KeyEvent evt) {
            char c1 = evt.getKeyChar();
            if (c1 >= '0' && c1 <= '9') {
                MasterMind.this.update(c1 - 48, this.zeile, this.spalte);
                evt.consume();
            } else if (c1 == '\n') {
                MasterMind.this.checkRow(this.zeile, this.spalte, this.spalte + 1);
            }
        }

        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 8) {
                if (MasterMind.this.rate[this.zeile][this.spalte].getText().length() == 0) {
                    MasterMind.this.rate[this.zeile][(this.spalte + MasterMind.this.n - 1) % MasterMind.this.n].setText("");
                    MasterMind.this.rate[this.zeile][(this.spalte + MasterMind.this.n - 1) % MasterMind.this.n].requestFocus();
                } else {
                    MasterMind.this.rate[this.zeile][this.spalte].setText("");
                }
                evt.consume();
            } else if (evt.getKeyCode() == 9) {
                MasterMind.this.checkRow(this.zeile, this.spalte, this.spalte + 1);
            }
        }

        public void focusGained(FocusEvent evt) {
        }

        public void focusLost(FocusEvent evt) {
            MasterMind.this.checkRow(this.zeile, this.spalte, this.spalte + 1);
        }
    }

    private final class HilfeDialog
    extends JDialog {
        public HilfeDialog() {
            super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, MasterMind.this));
            this.setTitle("Master Mind");
            this.setModal(false);
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            JTextArea t = new JTextArea(resources.getString("hilfe"), 15, 40);
            t.setLineWrap(true);
            t.setWrapStyleWord(true);
            this.getContentPane().add((Component)new JScrollPane(t), "Center");
            this.setDefaultCloseOperation(1);
            this.pack();
        }
    }

    private class NeuDialog
    extends JDialog
    implements ActionListener {
        private JLabel grussLabel;
        private JLabel zeitLabel;
        private JLabel versucheLabel;
        JSlider slider;
        JRadioButton mensch;
        JCheckBox nachricht1;
        private HilfeDialog hilfeDialog;

        public NeuDialog() {
            super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, MasterMind.this));
            this.hilfeDialog = null;
            this.initGui();
        }

        private void initGui() {
            this.setModal(true);
            this.setTitle(resources.getString("neudialog.title"));
            if (MasterMind.this.standAlone) {
                this.addWindowListener(closer);
            } else {
                this.setDefaultCloseOperation(2);
            }
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gc = new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 0, 10), 0, 0);
            this.getContentPane().setLayout(gbl);
            this.grussLabel = new JLabel(resources.getString("neudialog.hallo"), 0);
            this.grussLabel.setForeground(Color.green.darker());
            this.grussLabel.setFont(font);
            this.getContentPane().add((Component)this.grussLabel, gc);
            gc.gridy = 1;
            this.zeitLabel = new JLabel(resources.getString("neudialog.frage"), 0);
            this.getContentPane().add((Component)this.zeitLabel, gc);
            gc.gridy = 2;
            this.versucheLabel = new JLabel("", 0);
            this.getContentPane().add((Component)this.versucheLabel, gc);
            JPanel p = new JPanel(new BorderLayout());
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, resources.getString("neudialog.zahlen"));
            title.setTitleJustification(1);
            p.setBorder(title);
            this.slider = new JSlider(0, 3, 7, 3);
            this.slider.setMajorTickSpacing(2);
            this.slider.setMinorTickSpacing(1);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            p.add((Component)this.slider, "Center");
            gc.gridwidth = 2;
            gc.gridy = 3;
            this.getContentPane().add((Component)p, gc);
            p = new JPanel(new GridLayout(2, 1));
            title = BorderFactory.createTitledBorder(loweredetched, resources.getString("neudialog.wer"));
            title.setTitleJustification(1);
            p.setBorder(title);
            ButtonGroup bg = new ButtonGroup();
            this.mensch = new JRadioButton(resources.getString("neudialog.mensch"));
            this.mensch.setSelected(true);
            bg.add(this.mensch);
            p.add(this.mensch);
            JRadioButton r = new JRadioButton("Computer");
            p.add(r);
            bg.add(r);
            gc.gridx = 2;
            gc.insets = new Insets(10, 0, 0, 10);
            this.getContentPane().add((Component)p, gc);
            gc.gridx = 0;
            gc.gridy = 4;
            gc.gridwidth = 3;
            this.nachricht1 = new JCheckBox(resources.getString("neudialog.nachricht"));
            this.getContentPane().add((Component)this.nachricht1, gc);
            gc.gridx = 0;
            gc.gridy = 5;
            gc.gridwidth = MasterMind.this.standAlone ? 1 : 1;
            gc.anchor = 13;
            gc.insets = new Insets(10, 10, 10, 0);
            JButton bu = new JButton(resources.getString("neudialog.start"));
            this.getContentPane().add((Component)bu, gc);
            this.getRootPane().setDefaultButton(bu);
            bu.addActionListener(this);
            if (MasterMind.this.standAlone) {
                gc.gridx = 1;
                gc.anchor = 17;
                bu = new JButton(resources.getString("neudialog.ende"));
                bu.setMnemonic(27);
                this.getContentPane().add((Component)bu, gc);
                bu.addActionListener(this);
            }
            gc.gridx = 2;
            gc.gridwidth = 1;
            gc.anchor = 17;
            gc.insets = new Insets(10, 10, 10, 10);
            bu = new JButton(resources.getString("neudialog.help"));
            this.getContentPane().add((Component)bu, gc);
            bu.addActionListener(this);
            this.pack();
        }

        public void actionPerformed(ActionEvent evt) {
            if (resources.getString("neudialog.start").equals(((JButton)evt.getSource()).getText())) {
                this.hide();
            } else if (resources.getString("neudialog.ende").equals(((JButton)evt.getSource()).getText())) {
                System.exit(0);
            } else {
                if (this.hilfeDialog == null) {
                    this.hilfeDialog = new HilfeDialog();
                }
                this.hilfeDialog.show();
            }
        }

        public void setErgebnis(boolean gewonnen, String sekunden, String prozentVersuche) {
            Color farbe;
            String g;
            if (gewonnen) {
                g = resources.getString("ergebnis.gewonnen");
                farbe = Color.red;
            } else {
                g = resources.getString("ergebnis.verloren");
                farbe = Color.magenta.darker().darker();
            }
            this.grussLabel.setForeground(farbe);
            this.grussLabel.setText(g);
            this.zeitLabel.setText(sekunden);
            this.versucheLabel.setText(prozentVersuche);
            this.pack();
        }
    }
}

